<# // Copyright (c) Microsoft Corporation. Todos los derechos reservados. Licenciado bajo la licencia MIT. \ n Consulte Licencia en la raíz del proyecto para obtener información sobre la licencia. #>
<# @ template debug = "true" hostspecific = "true" language = "C #" #>
<# @ output extension = "\\" #>
<#
Host CustomT4Host = Host (CustomT4Host);
Modelo OdcmModel = host.CurrentModel;
CodeWriterPHP escritor = (CodeWriterPHP) host.CodeWriter;
TemplateWriterSettings settings = ConfigurationService.Settings;
Complejo OdcmClass = (OdcmClass) host.CurrentType;
String complexName = complex.Name.SanitizeEntityName ();
string targetNamespace = @ "Microsoft \ Graph \ Model";
String complexBaseName = "";
si (base compleja! = nulo)
	complexBaseName = complex.Base.Name.SanitizeEntityName ();

// TemplateWriterSettings.Properties se establecen en la línea de comandos de Typewriter. Verifica la línea de comando
// documentación para obtener más información sobre cómo se utiliza TemplateWriterSettings.Properties.
if (settings.Properties.ContainsKey ("php.namespace"))
{
    targetNamespace = settings.Properties ["php.namespace"];
}      

#>
<# = writer.WriteHeader (escritor.GetDocBlock (complexName.ToCheckedCase ())) #>
espacio de nombres <# = targetNamespace #>;
<# = writer.GetClassBlock (complexName.ToCheckedCase (). ToString (), "Model") #>
<#
if (complex.Base! = null) {
#>
class <# = complexName.ToCheckedCase () #> extiende <# = complexBaseName.ToCheckedCase () #>
<#
} más {
#>
class <# = complexName.ToCheckedCase () #> extiende Entidad
<#
}
#>
{
<# 
// Genere un constructor para inicializar la propiedad @ odata.type cuando este tipo no es abstracto y si este 
// la base del tipo es abstracta y se hace referencia a la base como el tipo de propiedad estructural. Necesitamos esto
// para eliminar la ambigüedad del tipo de clase descendiente que se envía. 
if (complex.IsBaseAbstractAndReferencedAsPropertyType () &&! complex.IsAbstract)
{
#> / **
    * Establezca @ odata.type ya que este tipo desciende inmediatamente de un resumen
    * tipo al que se hace referencia como el tipo en una entidad.
    * /
    función pública __construct ()
    {
        $ this-> setODataType ("# <# = complex.FullName #>");
    }

<# 
}
foreach (propiedad var en complex.Properties.Where (prop => prop.Type.GetTypeString ()! = "bytes")) {
    var propertyName = property.Name.SanitizePropertyName (complexName);
    if (! property.Type.IsComplex ()) {
#>
    / **
    * Obtiene el <# = propertyName #>
<# if (property.LongDescription! = null || property.Description! = null) {
#>
    * <# = propiedad.GetSanitizedLongDescription () #>
<#} #>
    *
    * @return <# = property.Type.GetTypeString () #> El <# = propertyName #>
    * /
    función pública get <# = propertyName.ToCheckedCase () #> ()
    {
        if (array_key_exists ("<# = property.Name.ToCamelize () #>", $ this -> _ propDict)) {
<#
            if (property.Type.GetTypeString () == "\\ DateTime") {
#>
            return new \ DateTime ($ this -> _ propDict ["<# = property.Name.ToCamelize () #>"]);
<#
            } más {
#>
            return $ this -> _ propDict ["<# = property.Name.ToCamelize () #>"];
<#
            }
#>
        } más {
            devolver nulo;
        }
    }

    / **
    * Establece <# = propertyName #>
<# if (property.LongDescription! = null || property.Description! = null) {
#>
    * <# = propiedad.GetSanitizedLongDescription () #>
<#} #>
    *
    * @param <# = property.Type.GetTypeString () #> $ val El valor de <# = propertyName #>
    *
    * @return <# = complexName.ToCheckedCase () #>
    * /
    conjunto de funciones públicas <# = propertyName.ToCheckedCase () #> ($ val)
    {
<#
            if (property.Type.GetTypeString () == "\\ DateTime") {
#>
        $ this -> _ propDict ["<# = property.Name.ToCamelize () #>"] 
            = $ val-> formato (\ DateTime :: ISO8601). "Z";
<#
            } más {
#>
        $ this -> _ propDict ["<# = property.Name.ToCamelize () #>"] = $ val;
<#
            }
#>
        return $ this;
    }
<#
   } más {
#>

    / **
    * Obtiene el <# = propertyName #>
<# if (property.LongDescription! = null || property.Description! = null) {
#>
    * <# = propiedad.GetSanitizedLongDescription () #>
<#} #>
    *
    * @return <# = property.Type.GetTypeString (). SanitizeEntityName (). ToCheckedCase () #> El <# = propertyName #>
    * /
    función pública get <# = propertyName.ToCheckedCase () #> ()
    {
        if (array_key_exists ("<# = property.Name.ToCamelize () #>", $ this -> _ propDict)) {
<#
// Compruebe si este tipo es un tipo de modelo generado o un tipo PHP
if (property.Type.GetTypeString () [0] == '\\') {#>
            if (is_a ($ this -> _ propDict ["<# = property.Name.ToCamelize () #>"], "<# = property.Type.GetTypeString () #>")) {
<#} más {#>
            if (is_a ($ this -> _ propDict ["<# = property.Name.ToCamelize () #>"], "<# = targetNamespace #> \ <# = property.Type.GetTypeString () #>")) {
<#} #>
                return $ this -> _ propDict ["<# = property.Name.ToCamelize () #>"];
            } más {
<# if (property.Type.GetTypeString () == "\\ GuzzleHttp \\ Psr7 \\ Stream") {#>
                $ this -> _ propDict ["<# = property.Name.ToCamelize () #>"] = \ GuzzleHttp \ Psr7 \ stream_for ($ this -> _ propDict ["<# = property.Name.ToCamelize () #>"] );
                return $ this -> _ propDict ["<# = property.Name.ToCamelize () #>"];
<#} más {#>
                $ this -> _ propDict ["<# = property.Name.ToCamelize () #>"] = new <# = property.Type.GetTypeString (). SanitizeEntityName (). ToCheckedCase () #> ($ this -> _ propDict [ "<# = property.Name.ToCamelize () #>"]);
                return $ this -> _ propDict ["<# = property.Name.ToCamelize () #>"];
<#} #>
            }
        }
        devolver nulo;
    }

    / **
    * Establece <# = propertyName #>
<# if (property.LongDescription! = null || property.Description! = null) {
#>
    * <# = propiedad.GetSanitizedLongDescription () #>
<#} #>
    *
    * @param <# = property.Type.GetTypeString () #> $ val El valor para asignar a la <# = property.Name #>
    *
    * @return <# = complexName.ToCheckedCase () #> El <# = complexName.ToCheckedCase () #>
    * /
    conjunto de funciones públicas <# = propertyName.ToCheckedCase () #> ($ val)
    {
<# if (property.Type.GetTypeString () == "bool") {#>
        $ esto -> _ propDict ["<# = propiedad.Nombre #>"] = boolval ($ val);
<#} else if (property.Type.GetTypeString () == "int") {#>
        $ esto -> _ propDict ["<# = propiedad.Nombre #>"] = intval ($ val);
<#} más {#>
        $ esto -> _ propDict ["<# = propiedad.Nombre #>"] = $ val;
<#} #>
         return $ this;
    }
<#
        }
    }
#>
}