<?php
//about theme info
add_action( 'admin_menu', 'expert_mechanic_gettingstarted' );
function expert_mechanic_gettingstarted() {    	
	add_theme_page( esc_html__('About Theme', 'expert-mechanic'), esc_html__('About Theme', 'expert-mechanic'), 'edit_theme_options', 'expert_mechanic_guide', 'expert_mechanic_mostrar_guide');   
}

// Add a Custom CSS file to WP Admin Area
function expert_mechanic_admin_theme_style() {
   wp_enqueue_style('custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/getting-started/getting-started.css');
}
add_action('admin_enqueue_scripts', 'expert_mechanic_admin_theme_style');

//guidline for about theme
function expert_mechanic_mostrar_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'expert-mechanic' );

?>

<div class="wrapper-info">
	<div class="col-left">
		<div class="intro">
			<h3><?php esc_html_e( 'Welcome to Expert Mechanic WordPress Theme', 'expert-mechanic' ); ?> <span>Version: <?php echo esc_html($theme['Version']);?></span></h3>
		</div>
		<div class="started">
			<hr>
			<div class="free-doc">
				<div class="lz-4">
					<h4><?php esc_html_e( 'Start Customizing', 'expert-mechanic' ); ?></h4>
					<ul>
						<span><?php esc_html_e( 'Go to', 'expert-mechanic' ); ?> <a target="_blank" href="<?php echo esc_url( admin_url('customize.php') ); ?>"><?php esc_html_e( 'Customizer', 'expert-mechanic' ); ?> </a> <?php esc_html_e( 'and start customizing your website', 'expert-mechanic' ); ?></span>
					</ul>
				</div>
				<div class="lz-4">
					<h4><?php esc_html_e( 'Support', 'expert-mechanic' ); ?></h4>
					<ul>
						<span><?php esc_html_e( 'Send your query to our', 'expert-mechanic' ); ?> <a href="<?php echo esc_url( EXPERT_MECHANIC_SUPPORT ); ?>" target="_blank"> <?php esc_html_e( 'Support', 'expert-mechanic' ); ?></a></span>
					</ul>
				</div>
			</div>
			<p><?php esc_html_e( 'Expert Mechanic is a resourceful WordPress theme that is designed to cater to the needs of auto-industry related websites. This multipurpose theme is an excellent option for representing your garage, car washing, serviceman, motor and repair shop, mechanical workshops, automotive, garage, handyman, automobile industry etc. It is specifically constructed to satisfy the needs of different kinds of automobile service provider websites. It includes a interactive pages that give a stunning look to the site. This theme bears a minimal design that makes sure that your site shows just the important stuff. It also makes your website load faster and doesn’t cause your visitors to lose interest. You can meet your branding as well as visual needs by making use of the personalization options provided in the theme. You can translate the website into any local or global language as it is made translation ready by making it compatible with WPML. Its animated effects take your website to an altogether different level. There are various sections for showing different aspects of your business such as information about your staff, the different services you offer etc. This elegantly designed theme has optimized codes that ensure the smooth and hassle-free performance of your site.', 'expert-mechanic')?></p>
			<hr>			
			<div class="col-left-inner">
				<h3><?php esc_html_e( 'Get started with Free Expert Mechanic Theme', 'expert-mechanic' ); ?></h3>
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/customizer-image.png" alt="" />
			</div>
		</div>
	</div>
	<div class="col-right">
		<div class="col-left-area">
			<h3><?php esc_html_e('Premium Theme Information', 'expert-mechanic'); ?></h3>
			<hr>
		</div>
		<div class="centerbold">
			<a href="<?php echo esc_url( EXPERT_MECHANIC_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'expert-mechanic'); ?></a>
			<a href="<?php echo esc_url( EXPERT_MECHANIC_BUY_NOW ); ?>"><?php esc_html_e('Buy Pro', 'expert-mechanic'); ?></a>
			<a href="<?php echo esc_url( EXPERT_MECHANIC_PRO_DOCS ); ?>" target="_blank"><?php esc_html_e('Pro Documentation', 'expert-mechanic'); ?></a>
			<hr class="secondhr">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/expert-mechanic.jpg" alt="" />
		</div>
		<h3><?php esc_html_e( 'PREMIUM THEME FEATURES', 'expert-mechanic'); ?></h3>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon01.png" alt="" />
			<h4><?php esc_html_e( 'Banner Slider', 'expert-mechanic'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon02.png" alt="" />
			<h4><?php esc_html_e( 'Theme Options', 'expert-mechanic'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon03.png" alt="" />
			<h4><?php esc_html_e( 'Custom Innerpage Banner', 'expert-mechanic'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon04.png" alt="" />
			<h4><?php esc_html_e( 'Custom Colors and Images', 'expert-mechanic'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon05.png" alt="" />
			<h4><?php esc_html_e( 'Fully Responsive', 'expert-mechanic'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon06.png" alt="" />
			<h4><?php esc_html_e( 'Hide/Show Sections', 'expert-mechanic'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon07.png" alt="" />
			<h4><?php esc_html_e( 'Woocommerce Support', 'expert-mechanic'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon08.png" alt="" />
			<h4><?php esc_html_e( 'Limit to display number of Posts', 'expert-mechanic'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon09.png" alt="" />
			<h4><?php esc_html_e( 'Multiple Page Templates', 'expert-mechanic'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon10.png" alt="" />
			<h4><?php esc_html_e( 'Custom Read More link', 'expert-mechanic'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon11.png" alt="" />
			<h4><?php esc_html_e( 'Code written with WordPress standard', 'expert-mechanic'); ?></h4>
		</div>
		<div class="lz-6">
			<img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/getting-started/images/icon12.png" alt="" />
			<h4><?php esc_html_e( '100% Multi language', 'expert-mechanic'); ?></h4>
		</div>
	</div>
</div>
<?php } ?>