<?php
/**
 * Expert Mechanic functions and definitions
 *
 * @subpackage Expert Mechanic
 * @since 1.0
 */

include get_theme_file_path( 'vendor/wptrt/autoload/src/Expert_Mechanic_Loader.php' );

$expert_mechanic_loader = new \WPTRT\Autoload\Expert_Mechanic_Loader();

$expert_mechanic_loader->expert_mechanic_add( 'WPTRT\\Customize\\Section', get_theme_file_path( 'vendor/wptrt/customize-section-button/src' ) );

$expert_mechanic_loader->expert_mechanic_register();

function expert_mechanic_setup() {
	
	load_theme_textdomain( 'expert-mechanic', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'responsive-embeds' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'custom-background', $defaults = array(
    'default-color'          => '',
    'default-image'          => '',
    'default-repeat'         => '',
    'default-position-x'     => '',
    'default-attachment'     => '',
    'wp-head-callback'       => '_custom_background_cb',
    'admin-head-callback'    => '',
    'admin-preview-callback' => ''
	));

	$GLOBALS['content_width'] = 525;
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'expert-mechanic' ),
	) );

	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'       => 250,
		'height'      => 250,
		'flex-width'  => true,
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
 	 */
	add_editor_style( array( 'assets/css/editor-style.css', expert_mechanic_fonts_url() ) );

	// Theme Activation Notice
	global $pagenow;

		if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) {
		add_action( 'admin_notices', 'expert_mechanic_activation_notice' );
	}

}
add_action( 'after_setup_theme', 'expert_mechanic_setup' );

// Notice after Theme Activation
function expert_mechanic_activation_notice() {
	echo '<div class="notice notice-success is-dismissible start-notice">';
		echo '<h3>'. esc_html__( 'Welcome to Luzuk!!', 'expert-mechanic' ) .'</h3>';
		echo '<p>'. esc_html__( 'Thank you for choosing Expert Mechanic theme. It will be our pleasure to have you on our Welcome page to serve you better.', 'expert-mechanic' ) .'</p>';
		echo '<p><a href="'. esc_url( admin_url( 'themes.php?page=expert_mechanic_guide' ) ) .'" class="button button-primary">'. esc_html__( 'GET STARTED', 'expert-mechanic' ) .'</a></p>';
	echo '</div>';
}

function expert_mechanic_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'expert-mechanic' ),
		'id'            => 'sidebar-1',
		'description'   => __( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'expert-mechanic' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="widget_container"><h2 class="widget-title">',
		'after_title'   => '</h2></div>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar 2', 'expert-mechanic' ),
		'id'            => 'sidebar-2',
		'description'   => __( 'Add widgets here to appear in your pages and posts', 'expert-mechanic' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="widget_container"><h2 class="widget-title">',
		'after_title'   => '</h2></div>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar 3', 'expert-mechanic' ),
		'id'            => 'sidebar-3',
		'description'   => __( 'Add widgets here to appear in your pages and posts', 'expert-mechanic' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<div class="widget_container"><h2 class="widget-title">',
		'after_title'   => '</h2></div>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 1', 'expert-mechanic' ),
		'id'            => 'footer-1',
		'description'   => __( 'Add widgets here to appear in your footer.', 'expert-mechanic' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 2', 'expert-mechanic' ),
		'id'            => 'footer-2',
		'description'   => __( 'Add widgets here to appear in your footer.', 'expert-mechanic' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 3', 'expert-mechanic' ),
		'id'            => 'footer-3',
		'description'   => __( 'Add widgets here to appear in your footer.', 'expert-mechanic' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 4', 'expert-mechanic' ),
		'id'            => 'footer-4',
		'description'   => __( 'Add widgets here to appear in your footer.', 'expert-mechanic' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

}
add_action( 'widgets_init', 'expert_mechanic_widgets_init' );

function expert_mechanic_fonts_url(){
	$font_url = '';
	$font_family = array();
	$font_family[] = 'Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';

	$query_args = array(
		'family'	=> rawurlencode(implode('|',$font_family)),
	);
	$font_url = add_query_arg($query_args,'//fonts.googleapis.com/css');
	return $font_url;
}

//Enqueue scripts and styles.
function expert_mechanic_scripts() {
	// Add custom fonts, used in the main stylesheet.
	wp_enqueue_style( 'expert-mechanic-fonts', expert_mechanic_fonts_url(), array(), null );
	
	//Bootstarp 
	wp_enqueue_style( 'bootstrap-css', esc_url(get_template_directory_uri()).'/assets/css/bootstrap.css' );
	
	// Theme stylesheet.
	wp_enqueue_style( 'expert-mechanic-basic-style', get_stylesheet_uri() );

	// Load the Internet Explorer 9 specific stylesheet, to fix display issues in the Customizer.
	if ( is_customize_preview() ) {
		wp_enqueue_style( 'expert-mechanic-ie9', get_theme_file_uri( '/assets/css/ie9.css' ), array( 'expert-mechanic-style' ), '1.0' );
		wp_style_add_data( 'expert-mechanic-ie9', 'conditional', 'IE 9' );
	}
	// Load the Internet Explorer 8 specific stylesheet.
	wp_enqueue_style( 'expert-mechanic-ie8', get_theme_file_uri( '/assets/css/ie8.css' ), array( 'expert-mechanic-style' ), '1.0' );
	wp_style_add_data( 'expert-mechanic-ie8', 'conditional', 'lt IE 9' );

	//font-awesome
	wp_enqueue_style( 'font-awesome-css', esc_url(get_template_directory_uri()).'/assets/css/fontawesome-all.css' );

	$custom_css = '';

	$expert_mechanic_logo_top_padding = get_theme_mod('expert_mechanic_logo_top_padding');
	$expert_mechanic_logo_bottom_padding = get_theme_mod('expert_mechanic_logo_bottom_padding');
	$expert_mechanic_logo_left_padding = get_theme_mod('expert_mechanic_logo_left_padding');
	$expert_mechanic_logo_right_padding = get_theme_mod('expert_mechanic_logo_right_padding');

	$expert_mechanic_service_section_padding = get_theme_mod('expert_mechanic_service_section_padding');

	$custom_css = '
		.logo {
			padding-top: '.esc_attr($expert_mechanic_logo_top_padding).'px;
			padding-bottom: '.esc_attr($expert_mechanic_logo_bottom_padding).'px;
			padding-left: '.esc_attr($expert_mechanic_logo_left_padding).'px;
			padding-right: '.esc_attr($expert_mechanic_logo_right_padding).'px;
		}
		#our_service {
			padding-top: '.esc_attr($expert_mechanic_service_section_padding).'px;
			padding-bottom: '.esc_attr($expert_mechanic_service_section_padding).'px;
		}
	';
	wp_add_inline_style( 'expert-mechanic-basic-style',$custom_css );

	// Load the html5 shiv.
	wp_enqueue_script( 'html5-js', get_theme_file_uri( '/assets/js/html5.js' ), array(), '3.7.3' );
	wp_script_add_data( 'html5-js', 'conditional', 'lt IE 9' );

	wp_enqueue_script( 'expert-mechanic-navigation-jquery', get_theme_file_uri( '/assets/js/navigation.js' ), array( 'jquery' ), '2.1.2', true );
	wp_enqueue_script( 'bootstrap-js', esc_url(get_template_directory_uri()) . '/assets/js/bootstrap.js', array('jquery') );
	wp_enqueue_script( 'jquery-superfish', esc_url(get_template_directory_uri()) . '/assets/js/jquery.superfish.js', array('jquery') ,'',true);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'expert_mechanic_scripts' );

function expert_mechanic_front_page_template( $template ) {
	return is_home() ? '' : $template;
}
add_filter( 'frontpage_template',  'expert_mechanic_front_page_template' );

function expert_mechanic_sanitize_dropdown_pages( $page_id, $setting ) {
  // Ensure $input is an absolute integer.
  $page_id = absint( $page_id );
  // If $page_id is an ID of a published page, return it; otherwise, return the default.
  return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}

function expert_mechanic_sanitize_choices( $input, $setting ) {
    global $wp_customize; 
    $control = $wp_customize->get_control( $setting->id ); 
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}

function expert_mechanic_sanitize_select( $input, $setting ) {
	// Ensure input is a slug.
	$input = sanitize_key( $input );

	// Get list of choices from the control associated with the setting.
	$choices = $setting->manager->get_control( $setting->id )->choices;

	// If the input is a valid key, return it; otherwise, return the default.
	return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
}

function expert_mechanic_sanitize_phone_number( $phone ) {
return preg_replace( '/[^\d+]/', '', $phone );
}

function expert_mechanic_sanitize_checkbox( $input ) {
	
	// Boolean check 
	return ( ( isset( $input ) && true == $input ) ? true : false );
}

function expert_mechanic_sanitize_float( $input ) {
    return filter_var($input, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
}

/* Excerpt Limit Begin */
function expert_mechanic_string_limit_words($string, $word_limit) {
	$words = explode(' ', $string, ($word_limit + 1));
	if(count($words) > $word_limit)
	array_pop($words);
	return implode(' ', $words);
}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'expert_mechanic_loop_columns');
	if (!function_exists('expert_mechanic_loop_columns')) {
		function expert_mechanic_loop_columns() {
	return 3; // 3 products per row
	}
}

function expert_mechanic_odd_or_even($counter){
    if($counter % 2 == 0){
        return "even";
    }
    else{
        return "odd";
    }
}

define('EXPERT_MECHANIC_LIVE_DEMO',__('https://www.luzukdemo.com/demo/expert-mechanic/','expert-mechanic'));
define('EXPERT_MECHANIC_PRO_DOCS',__('https://www.luzukdemo.com/docs/expert-mechanic/','expert-mechanic'));
define('EXPERT_MECHANIC_BUY_NOW',__('https://www.luzuk.com/product/mechanic-wordpress-theme/','expert-mechanic'));
define('EXPERT_MECHANIC_SUPPORT',__('https://wordpress.org/support/theme/expert-mechanic/','expert-mechanic'));
define('EXPERT_MECHANIC_CREDIT',__('https://www.luzuk.com/themes/free-mechanic-wordpress-theme/','expert-mechanic'));

if ( ! function_exists( 'expert_mechanic_credit' ) ) {
	function expert_mechanic_credit(){
		echo "<a href=".esc_url(EXPERT_MECHANIC_CREDIT)." target='_blank'>".esc_html__('Expert Mechanic WordPress Theme','expert-mechanic')."</a>";
	}
}

require get_parent_theme_file_path( '/inc/custom-header.php' );

require get_parent_theme_file_path( '/inc/template-tags.php' );

require get_parent_theme_file_path( '/inc/template-functions.php' );

require get_parent_theme_file_path( '/inc/customizer.php' );

require get_parent_theme_file_path( '/inc/getting-started/getting-started.php' );