

/*=============================================
SUBIENDO LA FOTO DEL USUARIO
=============================================*/
$(".nuevaFoto").change(function(){

	var imagen = this.files[0];
	
	/*=============================================
  	VALIDAMOS EL FORMATO DE LA IMAGEN SEA JPG O PNG
  	=============================================*/

  	if(imagen["type"] != "image/jpeg" && imagen["type"] != "image/png"){

  		$(".nuevaFoto").val("");

  		 swal({
		      title: "Error al subir la imagen",
		      text: "¡La imagen debe estar en formato JPG o PNG!",
		      type: "error",
		      confirmButtonText: "¡Cerrar!"
		    });

  	}else if(imagen["size"] > 2000000){

  		$(".nuevaFoto").val("");

  		 swal({
		      title: "Error al subir la imagen",
		      text: "¡La imagen no debe pesar más de 2MB!",
		      type: "error",
		      confirmButtonText: "¡Cerrar!"
		    });

  	}else{

  		var datosImagen = new FileReader;
  		datosImagen.readAsDataURL(imagen);

  		$(datosImagen).on("load", function(event){

  			var rutaImagen = event.target.result;

  			$(".previsualizar").attr("src", rutaImagen);

  		})

  	}
})

/*=============================================
EDITAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnEditarSuplente", function(){

	var idSuplente = $(this).attr("idSuplente");
	
	var datos = new FormData();
	datos.append("idSuplente", idSuplente);

	$.ajax({

		url:"ajax/suplentes.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta){
			
			$("#editarNombre").val(respuesta["nombre"]);
			$("#editarApep").val(respuesta["apellido_paterno"]);
			$("#editarApem").val(respuesta["apellido_materno"]);
			$("#editarCelular").val(respuesta["celular"]);
			$("#editarRut").val(respuesta["rut"]);
			
			$("#editarEmail").val(respuesta["email"]);
			$("#editarDireccion").val(respuesta["direccion"]);
			$("#editarFechaNacimiento").val(respuesta["fecha_nacimiento"]);
			$("#editarEcivil").val(respuesta["estadocivil"]);

			$("#editarGenero").val(respuesta["genero"]);
			$("#fotoActual").val(respuesta["foto"]);
			$("#editarApoderado").val(respuesta["id_apoderado"]);
			$("#idSuple").val(respuesta["id"]);


			if(respuesta["foto"] != ""){

				$(".previsualizarEditar").attr("src", respuesta["foto"]);

			}else{

				$(".previsualizarEditar").attr("src", "vistas/img/suplentes/default/anonymous.png");

			}

		}

	});

})

/*=============================================
ACTIVAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnActivar", function(){

	var idSuplente = $(this).attr("idSuplente");
	var estadoSuplente = $(this).attr("estadoSuplente");

	var datos = new FormData();
 	datos.append("activarId", idSuplente);
  	datos.append("activarSuplente", estadoSuplente);

  	$.ajax({

	  url:"ajax/suplentes.ajax.php",
	  method: "POST",
	  data: datos,
	  cache: false,
      contentType: false,
      processData: false,
      success: function(respuesta){

      		if(window.matchMedia("(max-width:767px)").matches){

	      		 swal({
			      title: "El suplente ha sido actualizado",
			      type: "success",
			      confirmButtonText: "¡Cerrar!"
			    }).then(function(result) {
			        if (result.value) {

			        	window.location = "suplentes";

			        }


				});

	      	}

      }

  	})

  	if(estadoSuplente == 0){

  		$(this).removeClass('btn-success');
  		$(this).addClass('btn-danger');
  		$(this).html('Desactivado');
  		$(this).attr('estadoSuplente',1);

  	}else{

  		$(this).addClass('btn-success');
  		$(this).removeClass('btn-danger');
  		$(this).html('Activado');
  		$(this).attr('estadoSuplente',0);

  	}

})

/*=============================================
REVISAR SI EL USUARIO YA ESTÁ REGISTRADO
=============================================*/

$("#nuevoSuplente").change(function(){

	$(".alert").remove();

	var suplente = $(this).val();

	var datos = new FormData();
	datos.append("validarSuplente", suplente);

	 $.ajax({
	    url:"ajax/suplentes.ajax.php",
	    method:"POST",
	    data: datos,
	    cache: false,
	    contentType: false,
	    processData: false,
	    dataType: "json",
	    success:function(respuesta){
	    	
	    	if(respuesta){

	    		$("#nuevoSuplente").parent().after('<div class="alert alert-warning">Este suplente ya existe en la base de datos</div>');

	    		$("#nuevoSuplente").val("");

	    	}

	    }

	})
})

/*=============================================
ELIMINAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnEliminarSuplente", function(){

  var idSuplente = $(this).attr("idSuplente");
  var fotoSuplente = $(this).attr("fotoSuplente");
  var suplente = $(this).attr("suplente");

  swal({
    title: '¿Está seguro de borrar el suplente?',
    text: "¡Si no lo está puede cancelar la accíón!",
    type: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, borrar suplente!'
  }).then(function(result){

    if(result.value){

      window.location = "index.php?ruta=suplentes&idSuplente="+idSuplente+"&suplente="+suplente+"&fotoSuplente="+fotoSuplente;

    }

  })

})




