

/*=============================================
SUBIENDO LA FOTO DEL USUARIO
=============================================*/
$(".nuevaFoto").change(function(){

	var imagen = this.files[0];
	
	/*=============================================
  	VALIDAMOS EL FORMATO DE LA IMAGEN SEA JPG O PNG
  	=============================================*/

  	if(imagen["type"] != "image/jpeg" && imagen["type"] != "image/png"){

  		$(".nuevaFoto").val("");

  		 swal({
		      title: "Error al subir la imagen",
		      text: "¡La imagen debe estar en formato JPG o PNG!",
		      type: "error",
		      confirmButtonText: "¡Cerrar!"
		    });

  	}else if(imagen["size"] > 2000000){

  		$(".nuevaFoto").val("");

  		 swal({
		      title: "Error al subir la imagen",
		      text: "¡La imagen no debe pesar más de 2MB!",
		      type: "error",
		      confirmButtonText: "¡Cerrar!"
		    });

  	}else{

  		var datosImagen = new FileReader;
  		datosImagen.readAsDataURL(imagen);

  		$(datosImagen).on("load", function(event){

  			var rutaImagen = event.target.result;

  			$(".previsualizar").attr("src", rutaImagen);

  		})

  	}
})

/*=============================================
EDITAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnEditarAlumno", function(){

	var idAlumno = $(this).attr("idAlumno");
	
	var datos = new FormData();
	datos.append("idAlumno", idAlumno);

	$.ajax({

		url:"ajax/alumnos.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta){
			
			$("#editarApoderado").val(respuesta["id_apoderado"]);
			$("#editarRut").val(respuesta["rut"]);
			$("#editarNombre").val(respuesta["nombre"]);
			$("#editarApep").val(respuesta["apellido_paterno"]);
			$("#editarApem").val(respuesta["apellido_materno"]);
			$("#editarFechaNacimiento").val(respuesta["fecha_nacimiento"]);
			
			$("#editarGenero").val(respuesta["genero"]);
			$("#editarNivel").val(respuesta["nivel"]);
			$("#editarJornada").val(respuesta["jornada"]);
			$("#editarAlergia").val(respuesta["alergia"]);
			
			$("#editarMisalud").val(respuesta["misalud"]);
			$("#editarIntervenciones").val(respuesta["intervenciones"]);
			$("#editarMedicamento_prohibido").val(respuesta["medicamento_prohibido"]);
			$("#editarTengo_alergia").val(respuesta["tengo_alergia"]);
			$("#editarControl_esfinter").val(respuesta["control_esfinter"]);
			$("#editarServicios_higienicos").val(respuesta["servicios_higienicos"]);
			$("#editarEdad_control").val(respuesta["edad_control"]);
			$("#editarSiesta").val(respuesta["siesta"]);
			$("#editarProhibicion_visitas").val(respuesta["prohibicion_visitas"]);
			$("#editarAutorizados_recojo").val(respuesta["autorizados_recojo"]);
			$("#editarCaso_emergencia").val(respuesta["caso_emergencia"]);
			$("#editarSeguros").val(respuesta["seguros"]);
			$("#editarTraslado_salud").val(respuesta["traslado_salud"]);
			$("#editarCentro_traslado").val(respuesta["centro_traslado"]);
			$("#editarSeguro_medico").val(respuesta["seguro_medico"]);
			
			
			//ID
			$("#editarAlumno").val(respuesta["id"]);


		}

	});

})

/*=============================================
ACTIVAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnActivar", function(){

	var idAlumno = $(this).attr("idAlumno");
	var estadoAlumno = $(this).attr("estadoAlumno");

	var datos = new FormData();
 	datos.append("activarId", idAlumno);
  	datos.append("activarAlumno", estadoAlumno);

  	$.ajax({

	  url:"ajax/alumnos.ajax.php",
	  method: "POST",
	  data: datos,
	  cache: false,
      contentType: false,
      processData: false,
      success: function(respuesta){

      		if(window.matchMedia("(max-width:767px)").matches){

	      		 swal({
			      title: "El alumno ha sido actualizado",
			      type: "success",
			      confirmButtonText: "¡Cerrar!"
			    }).then(function(result) {
			        if (result.value) {

			        	window.location = "alumnos";

			        }


				});

	      	}

      }

  	})

  	if(estadoAlumno == 0){

  		$(this).removeClass('btn-success');
  		$(this).addClass('btn-danger');
  		$(this).html('Desactivado');
  		$(this).attr('estadoAlumno',1);

  	}else{

  		$(this).addClass('btn-success');
  		$(this).removeClass('btn-danger');
  		$(this).html('Activado');
  		$(this).attr('estadoAlumno',0);

  	}

})

/*=============================================
REVISAR SI EL USUARIO YA ESTÁ REGISTRADO
=============================================*/

$("#nuevoAlumno").change(function(){

	$(".alert").remove();

	var alumno = $(this).val();

	var datos = new FormData();
	datos.append("validarAlumno", alumno);

	 $.ajax({
	    url:"ajax/alumnos.ajax.php",
	    method:"POST",
	    data: datos,
	    cache: false,
	    contentType: false,
	    processData: false,
	    dataType: "json",
	    success:function(respuesta){
	    	
	    	if(respuesta){

	    		$("#nuevoAlumno").parent().after('<div class="alert alert-warning">Este alumno ya existe en la base de datos</div>');

	    		$("#nuevoAlumno").val("");

	    	}

	    }

	})
})

/*=============================================
ELIMINAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnEliminarAlumno", function(){

  var idAlumno = $(this).attr("idAlumno");
  var fotoAlumno = $(this).attr("fotoAlumno");
  var alumno = $(this).attr("alumno");

  swal({
    title: '¿Está seguro de borrar el alumno?',
    text: "¡Si no lo está puede cancelar la accíón!",
    type: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, borrar alumno!'
  }).then(function(result){

    if(result.value){

      window.location = "index.php?ruta=alumnos&idAlumno="+idAlumno+"&alumno="+alumno+"&fotoAlumno="+fotoAlumno;

    }

  })

})