<?php

class ControladorRoles{

	/*=============================================
	CREAR Roles
	=============================================*/

	 public static function ctrCrearRol(){

		if(isset($_POST["nuevoRol"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoRol"])){

				$tabla = "roles";

				$datos = $_POST["nuevoRol"];

				$respuesta = ModeloRoles::mdlIngresarRol($tabla, $datos);

				if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "El rol ha sido guardada correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "roles";

									}
								})

					</script>';

				}


			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El Rol no puede ir vacía o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "roles";

							}
						})

			  	</script>';

			}

		}

	}

	/*=============================================
	MOSTRAR roles
	=============================================*/

	 public static function ctrMostrarRoles($item, $valor){

		$tabla = "roles";

		$respuesta = ModeloRoles::mdlMostrarRoles($tabla, $item, $valor);

		return $respuesta;
	
	}

	/*=============================================
	EDITAR Rol
	=============================================*/

	 public static function ctrEditarRol(){

		if(isset($_POST["editarRol"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["editarRol"])){

				$tabla = "roles";

				$datos = array("rol"=>$_POST["editarRol"],
							   "id"=>$_POST["idRol"]);

				$respuesta = ModeloRoles::mdlEditarRol($tabla, $datos);

				if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "El rol ha sido cambiada correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "roles";

									}
								})

					</script>';

				}


			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El rol no puede ir vacía o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "roles";

							}
						})

			  	</script>';

			}

		}

	}

	/*=============================================
	BORRAR Rol
	=============================================*/

	 public static function ctrBorrarRol(){

		if(isset($_GET["idRol"])){

			$tabla ="roles";
			$datos = $_GET["idRol"];

			$respuesta = ModeloRoles::mdlBorrarRol($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

					swal({
						  type: "success",
						  title: "El rol ha sido borrada correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "roles";

									}
								})

					</script>';
			}
		}
		
	}
}
