<?php

class ControladorNiveles{

	/*=============================================
	CREAR CATEGORIAS
	=============================================*/

	 public static function ctrCrearNivel(){

		if(isset($_POST["nuevaNivel"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevaNivel"])){

				$tabla = "niveles";

				$datos = $_POST["nuevaNivel"];

				$respuesta = ModeloNiveles::mdlIngresarNivel($tabla, $datos);

				if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "La categoría ha sido guardada correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "niveles";

									}
								})

					</script>';

				}


			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡La categoría no puede ir vacía o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "niveles";

							}
						})

			  	</script>';

			}

		}

	}

	/*=============================================
	MOSTRAR CATEGORIAS
	=============================================*/

	 public static function ctrMostrarNiveles($item, $valor){

		$tabla = "niveles";

		$respuesta = ModeloNiveles::mdlMostrarNiveles($tabla, $item, $valor);

		return $respuesta;
	
	}

	/*=============================================
	EDITAR CATEGORIA
	=============================================*/

	 public static function ctrEditarNivel(){

		if(isset($_POST["editarNivel"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["editarNivel"])){

				$tabla = "niveles";

				$datos = array("nivel"=>$_POST["editarNivel"],
							   "id"=>$_POST["idNivel"]);

				$respuesta = ModeloNiveles::mdlEditarNivel($tabla, $datos);

				if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "La categoría ha sido cambiada correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "niveles";

									}
								})

					</script>';

				}


			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡La categoría no puede ir vacía o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "niveles";

							}
						})

			  	</script>';

			}

		}

	}

	/*=============================================
	BORRAR CATEGORIA
	=============================================*/

	 public static function ctrBorrarNivel(){

		if(isset($_GET["idNivel"])){

			$tabla ="niveles";
			$datos = $_GET["idNivel"];

			$respuesta = ModeloNiveles::mdlBorrarNivel($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

					swal({
						  type: "success",
						  title: "La categoría ha sido borrada correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "niveles";

									}
								})

					</script>';
			}
		}
		
	}
}
