<?php

class ControladorJornadas{

	/*=============================================
	CREAR CATEGORIAS
	=============================================*/

	 public static function ctrCrearJornada(){

		if(isset($_POST["nuevaJornada"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevaJornada"])){

				$tabla = "jornadas";

				$datos = $_POST["nuevaJornada"];

				$respuesta = ModeloJornadas::mdlIngresarJornada($tabla, $datos);

				if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "La jornada ha sido guardada correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "jornadas";

									}
								})

					</script>';

				}


			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡La jornada no puede ir vacía o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "jornadas";

							}
						})

			  	</script>';

			}

		}

	}

	/*=============================================
	MOSTRAR CATEGORIAS
	=============================================*/

	 public static function ctrMostrarJornadas($item, $valor){

		$tabla = "jornadas";

		$respuesta = ModeloJornadas::mdlMostrarJornadas($tabla, $item, $valor);

		return $respuesta;
	
	}

	/*=============================================
	EDITAR CATEGORIA
	=============================================*/

	 public static function ctrEditarJornada(){

		if(isset($_POST["editarJornada"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["editarJornada"])){

				$tabla = "jornadas";

				$datos = array("jornada"=>$_POST["editarJornada"],
							   "id"=>$_POST["idJornada"]);

				$respuesta = ModeloJornadas::mdlEditarJornada($tabla, $datos);

				if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "La jornada ha sido cambiada correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "jornadas";

									}
								})

					</script>';

				}


			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡La jornada no puede ir vacía o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "jornadas";

							}
						})

			  	</script>';

			}

		}

	}

	/*=============================================
	BORRAR CATEGORIA
	=============================================*/

	 public static function ctrBorrarJornada(){

		if(isset($_GET["idJornada"])){

			$tabla ="jornadas";
			$datos = $_GET["idJornada"];

			$respuesta = ModeloJornadas::mdlBorrarJornada($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

					swal({
						  type: "success",
						  title: "La jornada ha sido borrada correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "jornadas";

									}
								})

					</script>';
			}
		}
		
	}
}
