

/*=============================================
SUBIENDO LA FOTO DEL USUARIO
=============================================*/
$(".nuevaFoto").change(function(){

	var imagen = this.files[0];
	
	/*=============================================
  	VALIDAMOS EL FORMATO DE LA IMAGEN SEA JPG O PNG
  	=============================================*/

  	if(imagen["type"] != "image/jpeg" && imagen["type"] != "image/png"){

  		$(".nuevaFoto").val("");

  		 swal({
		      title: "Error al subir la imagen",
		      text: "¡La imagen debe estar en formato JPG o PNG!",
		      type: "error",
		      confirmButtonText: "¡Cerrar!"
		    });

  	}else if(imagen["size"] > 2000000){

  		$(".nuevaFoto").val("");

  		 swal({
		      title: "Error al subir la imagen",
		      text: "¡La imagen no debe pesar más de 2MB!",
		      type: "error",
		      confirmButtonText: "¡Cerrar!"
		    });

  	}else{

  		var datosImagen = new FileReader;
  		datosImagen.readAsDataURL(imagen);

  		$(datosImagen).on("load", function(event){

  			var rutaImagen = event.target.result;

  			$(".previsualizar").attr("src", rutaImagen);

  		})

  	}
})

/*=============================================
EDITAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnEditarApoderado", function(){

	var idApoderado = $(this).attr("idApoderado");
	
	var datos = new FormData();
	datos.append("idApoderado", idApoderado);

	$.ajax({

		url:"ajax/apoderados.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta){
			
			$("#editarNombre").val(respuesta["nombre"]);
			$("#editarApep").val(respuesta["apellido_paterno"]);
			$("#editarApem").val(respuesta["apellido_materno"]);
			$("#editarCelular").val(respuesta["celular"]);
			$("#editarRut").val(respuesta["rut"]);
			
			$("#editarEmail").val(respuesta["email"]);
			$("#editarDireccion").val(respuesta["direccion"]);
			$("#editarFechaNacimiento").val(respuesta["fecha_nacimiento"]);
			$("#editarEcivil").val(respuesta["estadocivil"]);

			$("#editarApoderado").val(respuesta["usuario"]);
			$("#per").val(respuesta["perfil"]);
			$("#editarPerfil").val(respuesta["perfil"]);
			$("#fotoActual").val(respuesta["foto"]);

			$("#passwordActual").val(respuesta["password"]);

			if(respuesta["foto"] != ""){

				$(".previsualizarEditar").attr("src", respuesta["foto"]);

			}else{

				$(".previsualizarEditar").attr("src", "vistas/img/apoderados/default/anonymous.png");

			}

		}

	});

})

/*=============================================
ACTIVAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnActivar", function(){

	var idApoderado = $(this).attr("idApoderado");
	var estadoApoderado = $(this).attr("estadoApoderado");

	var datos = new FormData();
 	datos.append("activarId", idApoderado);
  	datos.append("activarApoderado", estadoApoderado);

  	$.ajax({

	  url:"ajax/apoderados.ajax.php",
	  method: "POST",
	  data: datos,
	  cache: false,
      contentType: false,
      processData: false,
      success: function(respuesta){

      		if(window.matchMedia("(max-width:767px)").matches){

	      		 swal({
			      title: "El apoderado ha sido actualizado",
			      type: "success",
			      confirmButtonText: "¡Cerrar!"
			    }).then(function(result) {
			        if (result.value) {

			        	window.location = "apoderados";

			        }


				});

	      	}

      }

  	})

  	if(estadoApoderado == 0){

  		$(this).removeClass('btn-success');
  		$(this).addClass('btn-danger');
  		$(this).html('Desactivado');
  		$(this).attr('estadoApoderado',1);

  	}else{

  		$(this).addClass('btn-success');
  		$(this).removeClass('btn-danger');
  		$(this).html('Activado');
  		$(this).attr('estadoApoderado',0);

  	}

})

/*=============================================
REVISAR SI EL USUARIO YA ESTÁ REGISTRADO
=============================================*/

$("#nuevoApoderado").change(function(){

	$(".alert").remove();

	var apoderado = $(this).val();

	var datos = new FormData();
	datos.append("validarApoderado", apoderado);

	 $.ajax({
	    url:"ajax/apoderados.ajax.php",
	    method:"POST",
	    data: datos,
	    cache: false,
	    contentType: false,
	    processData: false,
	    dataType: "json",
	    success:function(respuesta){
	    	
	    	if(respuesta){

	    		$("#nuevoApoderado").parent().after('<div class="alert alert-warning">Este apoderado ya existe en la base de datos</div>');

	    		$("#nuevoApoderado").val("");

	    	}

	    }

	})
})

/*=============================================
ELIMINAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnEliminarApoderado", function(){

  var idApoderado = $(this).attr("idApoderado");
  var fotoApoderado = $(this).attr("fotoApoderado");
  var apoderado = $(this).attr("apoderado");

  swal({
    title: '¿Está seguro de borrar el apoderado?',
    text: "¡Si no lo está puede cancelar la accíón!",
    type: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, borrar apoderado!'
  }).then(function(result){

    if(result.value){

      window.location = "index.php?ruta=apoderados&idApoderado="+idApoderado+"&apoderado="+apoderado+"&fotoApoderado="+fotoApoderado;

    }

  })

})




