<?php

require_once "conexion.php";

class ModeloApoderados{

	/*=============================================
	MOSTRAR USUARIOS
	=============================================*/

	public static function mdlMostrarApoderados($tabla, $item, $valor){
		$per = "3";
		if($item != null){
			$per = "3";
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE perfil = :perfil and $item = :$item");
			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
			$stmt -> bindParam(":perfil", $per, PDO::PARAM_STR);
			$stmt -> execute();
			return $stmt -> fetch();

		}elseif($valor != null){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla where perfil = :perfil");
			$stmt -> bindParam(":perfil", $valor, PDO::PARAM_STR);
			$stmt -> execute();
			return $stmt -> fetchAll();
		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla where perfil = :perfil");
			$stmt -> bindParam(":perfil", $per, PDO::PARAM_STR);
			$stmt -> execute();
			return $stmt -> fetchAll();
		}
		
		$stmt -> close();
		$stmt = null;

	}

	/*=============================================
	REGISTRO DE USUARIO
	=============================================*/

   public static function mdlIngresarApoderado($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(nombre, apellido_paterno, apellido_materno, genero, celular, email, direccion, estadocivil, fecha_nacimiento, rut, usuario, password, perfil, foto) VALUES (:nombre, :apep, :apem, :genero, :celular, :email, :direccion, :estadocivil, :fecha_nacimiento, :rut, :usuario, :password, :perfil, :foto)");

		$stmt->bindParam(":nombre", $datos["nombre"], PDO::PARAM_STR);
		$stmt->bindParam(":apep", $datos["apep"], PDO::PARAM_STR);
		$stmt->bindParam(":apem", $datos["apem"], PDO::PARAM_STR);
		$stmt->bindParam(":genero", $datos["genero"], PDO::PARAM_STR);
		$stmt->bindParam(":celular", $datos["celular"], PDO::PARAM_STR);
		$stmt->bindParam(":email", $datos["email"], PDO::PARAM_STR);
		$stmt->bindParam(":direccion", $datos["direccion"], PDO::PARAM_STR);
		$stmt->bindParam(":estadocivil", $datos["estadocivil"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_nacimiento", $datos["fecha_nacimiento"], PDO::PARAM_STR);
		$stmt->bindParam(":rut", $datos["rut"], PDO::PARAM_STR);
		
		$stmt->bindParam(":usuario", $datos["usuario"], PDO::PARAM_STR);
		$stmt->bindParam(":password", $datos["password"], PDO::PARAM_STR);
		$stmt->bindParam(":perfil", $datos["perfil"], PDO::PARAM_STR);
		$stmt->bindParam(":foto", $datos["foto"], PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok";	

		}else{

			return "error";
		
		}

		$stmt->close();
		
		$stmt = null;

	}

	/*=============================================
	EDITAR USUARIO
	=============================================*/

	 public static function mdlEditarApoderado($tabla, $datos){
	
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET nombre = :nombre, apellido_paterno = :apep, apellido_materno = :apem, celular = :celular, genero = :genero,
		 email = :email, direccion = :direccion, estadocivil = :estadocivil, fecha_nacimiento = :fecha_nacimiento, rut = :rut, password = :password, perfil = :perfil, foto = :foto WHERE usuario = :usuario");

		$stmt -> bindParam(":nombre", $datos["nombre"], PDO::PARAM_STR);
		$stmt -> bindParam(":apep", $datos["apep"], PDO::PARAM_STR);
		$stmt -> bindParam(":apem", $datos["apem"], PDO::PARAM_STR);
		$stmt -> bindParam(":genero", $datos["genero"], PDO::PARAM_STR);
		$stmt -> bindParam(":celular", $datos["celular"], PDO::PARAM_STR);
	    $stmt->bindParam(":email", $datos["email"], PDO::PARAM_STR);
		$stmt->bindParam(":direccion", $datos["direccion"], PDO::PARAM_STR);
		$stmt->bindParam(":estadocivil", $datos["estadocivil"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_nacimiento", $datos["fecha_nacimiento"], PDO::PARAM_STR);
		
		$stmt -> bindParam(":rut", $datos["rut"], PDO::PARAM_STR);
		$stmt -> bindParam(":password", $datos["password"], PDO::PARAM_STR);
		$stmt -> bindParam(":perfil", $datos["perfil"], PDO::PARAM_STR);
		$stmt -> bindParam(":foto", $datos["foto"], PDO::PARAM_STR);
		$stmt -> bindParam(":usuario", $datos["usuario"], PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	ACTUALIZAR USUARIO
	=============================================*/

	 public static function mdlActualizarApoderado($tabla, $item1, $valor1, $item2, $valor2){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE $item2 = :$item2");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;

	}

	/*=============================================
	BORRAR USUARIO
	=============================================*/

 public static function mdlBorrarApoderado($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE id = :id");

		$stmt -> bindParam(":id", $datos, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}

		$stmt -> close();

		$stmt = null;


	}

}