<?php

class ControladorSuplentes{

	/*=============================================
	INGRESO DE USUARIO
	=============================================*/

	 public static function ctrIngresoSuplente(){

		if(isset($_POST["ingSuplente"])){

			if(preg_match('/^[a-zA-Z0-9]+$/', $_POST["ingSuplente"]) &&
			   preg_match('/^[a-zA-Z0-9]+$/', $_POST["ingPassword"])){

				$tabla = "suplentes";

				$item = "usuario";
				$valor = $_POST["ingSuplente"];
				$pass  = filter_var($_POST["ingPassword"], FILTER_SANITIZE_STRING);;
				$respuesta = ModeloSuplentes::MdlMostrarSuplentes($tabla, $item, $valor);

/*if($respuesta["usuario"] == $_POST["ingSuplente"] && $respuesta["password"] == $_POST["ingPassword"]){*/
					if (password_verify($pass,$respuesta["password"])) {
					
					
					if($respuesta["estado"] == 1){

						$_SESSION["iniciarSesion"] = "ok";
						$_SESSION["id"] = $respuesta["id"];
						$_SESSION["nombre"] = $respuesta["nombre"];
						$_SESSION["usuario"] = $respuesta["usuario"];
						$_SESSION["foto"] = $respuesta["foto"];
						$_SESSION["perfil"] = $respuesta["perfil"];

						/*=============================================
						REGISTRAR FECHA PARA SABER EL ÚLTIMO LOGIN
						=============================================*/

						date_default_timezone_set('America/Bogota');

						$fecha = date('Y-m-d');
						$hora = date('H:i:s');

						$fechaActual = $fecha.' '.$hora;

						$item1 = "ultimo_login";
						$valor1 = $fechaActual;

						$item2 = "id";
						$valor2 = $respuesta["id"];

						$ultimoLogin = ModeloSuplentes::mdlActualizarSuplente($tabla, $item1, $valor1, $item2, $valor2);

						if($ultimoLogin == "ok"){

							echo '<script>

								window.location = "inicio";

							</script>';

						}				
						
					}else{

						echo '<br>
							<div class="alert alert-danger">El apoderado aún no está activado</div>';

					}		

				}else{

					echo '<br><div class="alert alert-danger">Error al ingresar, vuelve a intentarlo</div>';

				}

			}	

		}

	}

	/*=============================================
	REGISTRO DE USUARIO
	=============================================*/

 public static function ctrCrearSuplente(){

		if(isset($_POST["nuevoNombre"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoNombre"])){

			   	/*=============================================
				VALIDAR IMAGEN
				=============================================*/

				$ruta = "";

				if(isset($_FILES["nuevaFoto"]["tmp_name"])){

					/*=============================================
					CREAMOS EL DIRECTORIO DONDE VAMOS A GUARDAR LA FOTO DEL USUARIO
					=============================================*/

					$directorio = "vistas/img/suplentes/".$_POST["nuevoSuplente"];
					mkdir($directorio, 0755);

					/*=============================================
					DE ACUERDO AL TIPO DE IMAGEN APLICAMOS LAS FUNCIONES POR DEFECTO DE PHP
					=============================================*/

					if($_FILES["nuevaFoto"]["type"] == "image/jpeg"){

						/*=============================================
						GUARDAMOS LA IMAGEN EN EL DIRECTORIO
						=============================================*/
						$aleatorio = mt_rand(100,999);

						$ruta = "vistas/img/suplentes/".$_POST["nuevoSuplente"]."/".$aleatorio.".jpg";
					
						move_uploaded_file($_FILES["nuevaFoto"]["tmp_name"], $ruta);

					}

					if($_FILES["nuevaFoto"]["type"] == "image/png"){
						/*=============================================
						GUARDAMOS LA IMAGEN EN EL DIRECTORIO
						=============================================*/
						$aleatorio = mt_rand(100,999);
						$ruta = "vistas/img/suplentes/".$_POST["nuevoSuplente"]."/".$aleatorio.".png";					
						move_uploaded_file($_FILES["nuevaFoto"]["tmp_name"], $ruta);

					}

				}

				$tabla = "suplentes";
				//Nuevos

				$datos = array("nombre" => $_POST["nuevoNombre"],
					           "apep" => $_POST["nuevoApep"],
					           "apem" => $_POST["nuevoApem"],
					           "genero" => $_POST["nuevoGenero"],
					           "celular" => $_POST["nuevoCelular"],
					           "estadocivil" => $_POST["nuevoEcivil"],
					           "direccion" => $_POST["nuevoDireccion"],
					           "email" => $_POST["nuevoEmail"],
					           "fecha_nacimiento" => $_POST["nuevaFechaNacimiento"],
							   "id_apoderado" => $_POST["nuevoApoderado"],
					           "rut" => $_POST["nuevoRut"],
					           "foto"=>$ruta);
				$respuesta = ModeloSuplentes::mdlIngresarSuplente($tabla, $datos);
			
				if($respuesta == "ok"){

					echo '<script>

					swal({

						type: "success",
						title: "¡El apoderado ha sido guardado correctamente!",
						showConfirmButton: true,
						confirmButtonText: "Cerrar"

					}).then(function(result){

						if(result.value){
						
							window.location = "suplentes";

						}

					});
				

					</script>';


				}	


			}else{

				echo '<script>

					swal({

						type: "error",
						title: "¡El apoderado no puede ir vacío o llevar caracteres especiales!",
						showConfirmButton: true,
						confirmButtonText: "Cerrar"

					}).then(function(result){

						if(result.value){
						
							window.location = "suplentes";

						}

					});
				

				</script>';

			}


		}


	}

	/*=============================================
	MOSTRAR USUARIO
	=============================================*/

	public static function ctrMostrarSuplentes($item, $valor){

		$tabla = "suplentes";

		$respuesta = ModeloSuplentes::MdlMostrarSuplentes($tabla, $item, $valor);

		return $respuesta;
	}

	/*=============================================
	EDITAR USUARIO
	=============================================*/

	public static function ctrEditarSuplente(){

		if(isset($_POST["idSuple"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["editarNombre"])){

				/*=============================================
				VALIDAR IMAGEN
				=============================================*/

				$ruta = $_POST["fotoActual"];

				if(isset($_FILES["editarFoto"]["tmp_name"]) && !empty($_FILES["editarFoto"]["tmp_name"])){

					/*list($ancho, $alto) = getimagesize($_FILES["editarFoto"]["tmp_name"]);

					$nuevoAncho = 500;
					$nuevoAlto = 500;*/

					/*=============================================
					CREAMOS EL DIRECTORIO DONDE VAMOS A GUARDAR LA FOTO DEL USUARIO
					=============================================*/

					$directorio = "vistas/img/suplentes/".$_POST["editarSuplente"];

					/*=============================================
					PRIMERO PREGUNTAMOS SI EXISTE OTRA IMAGEN EN LA BD
					=============================================*/

					if(!empty($_POST["fotoActual"])){

						unlink($_POST["fotoActual"]);

					}else{

						mkdir($directorio, 0755);

					}	

					/*=============================================
					DE ACUERDO AL TIPO DE IMAGEN APLICAMOS LAS FUNCIONES POR DEFECTO DE PHP
					=============================================*/

					if($_FILES["editarFoto"]["type"] == "image/jpeg"){

						/*=============================================
						GUARDAMOS LA IMAGEN EN EL DIRECTORIO
						=============================================*/

						$aleatorio = mt_rand(100,999);

						$ruta = "vistas/img/suplentes/".$_POST["editarSuplente"]."/".$aleatorio.".jpg";

					
						move_uploaded_file($_FILES["editarFoto"]["tmp_name"], $ruta);

					}

					if($_FILES["editarFoto"]["type"] == "image/png"){

						/*=============================================
						GUARDAMOS LA IMAGEN EN EL DIRECTORIO
						=============================================*/

						$aleatorio = mt_rand(100,999);

						$ruta = "vistas/img/suplentes/".$_POST["editarSuplente"]."/".$aleatorio.".png";

						
						move_uploaded_file($_FILES["editarFoto"]["tmp_name"], $ruta);

					}

				}

				$tabla = "suplentes";

				
				//EditarRut,editarCelular,editarApem, editarApep
				$datos = array("nombre" => $_POST["editarNombre"],
							   "apep" => $_POST["editarApep"],
							   "apem" => $_POST["editarApem"],
							   "genero" => $_POST["editarGenero"],
							   "celular" => $_POST["editarCelular"],
							   "estadocivil" => $_POST["editarEcivil"],
					           "direccion" => $_POST["editarDireccion"],
					           "email" => $_POST["editarEmail"],
					           "fecha_nacimiento" => $_POST["editarFechaNacimiento"],
							   "id_apoderado" => $_POST["editarApoderado"],
							   "rut" => $_POST["editarRut"],
							   "id" => $_POST["idSuple"],
							   "foto" => $ruta);

				$respuesta = ModeloSuplentes::mdlEditarSuplente($tabla, $datos);

				if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "El apoderado ha sido editado correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result) {
									if (result.value) {

									window.location = "suplentes";

									}
								})

					</script>';

				}


			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El nombre no puede ir vacío o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result) {
							if (result.value) {

							window.location = "suplentes";

							}
						})

			  	</script>';

			}

		}

	}

	/*=============================================
	BORRAR USUARIO
	=============================================*/

 public static function ctrBorrarSuplente(){

		if(isset($_GET["idSuplente"])){

			$tabla ="suplentes";
			$datos = $_GET["idSuplente"];

			if($_GET["fotoSuplente"] != ""){

				unlink($_GET["fotoSuplente"]);
				rmdir('vistas/img/suplentes/'.$_GET["apoderado"]);

			}

			$respuesta = ModeloSuplentes::mdlBorrarSuplente($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

				swal({
					  type: "success",
					  title: "El apoderado ha sido borrado correctamente",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar",
					  closeOnConfirm: false
					  }).then(function(result) {
								if (result.value) {

								window.location = "suplentes";

								}
							})

				</script>';

			}		

		}

	}


}