<?php

class ControladorApoderados{

	/*=============================================
	INGRESO DE USUARIO
	=============================================*/

	 public static function ctrIngresoApoderado(){

		if(isset($_POST["ingApoderado"])){

			if(preg_match('/^[a-zA-Z0-9]+$/', $_POST["ingApoderado"]) &&
			   preg_match('/^[a-zA-Z0-9]+$/', $_POST["ingPassword"])){

				$tabla = "usuarios";

				$item = "usuario";
				$valor = $_POST["ingApoderado"];
				$pass  = filter_var($_POST["ingPassword"], FILTER_SANITIZE_STRING);;
				$respuesta = ModeloApoderados::MdlMostrarApoderados($tabla, $item, $valor);

/*if($respuesta["usuario"] == $_POST["ingApoderado"] && $respuesta["password"] == $_POST["ingPassword"]){*/
					if (password_verify($pass,$respuesta["password"])) {
					
					
					if($respuesta["estado"] == 1){

						$_SESSION["iniciarSesion"] = "ok";
						$_SESSION["id"] = $respuesta["id"];
						$_SESSION["nombre"] = $respuesta["nombre"];
						$_SESSION["usuario"] = $respuesta["usuario"];
						$_SESSION["foto"] = $respuesta["foto"];
						$_SESSION["perfil"] = $respuesta["perfil"];

						/*=============================================
						REGISTRAR FECHA PARA SABER EL ÚLTIMO LOGIN
						=============================================*/

						date_default_timezone_set('America/Bogota');

						$fecha = date('Y-m-d');
						$hora = date('H:i:s');

						$fechaActual = $fecha.' '.$hora;

						$item1 = "ultimo_login";
						$valor1 = $fechaActual;

						$item2 = "id";
						$valor2 = $respuesta["id"];

						$ultimoLogin = ModeloApoderados::mdlActualizarApoderado($tabla, $item1, $valor1, $item2, $valor2);

						if($ultimoLogin == "ok"){

							echo '<script>

								window.location = "inicio";

							</script>';

						}				
						
					}else{

						echo '<br>
							<div class="alert alert-danger">El apoderado aún no está activado</div>';

					}		

				}else{

					echo '<br><div class="alert alert-danger">Error al ingresar, vuelve a intentarlo</div>';

				}

			}	

		}

	}

	/*=============================================
	REGISTRO DE USUARIO
	=============================================*/

 public static function ctrCrearApoderado(){

		if(isset($_POST["nuevoApoderado"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoNombre"]) &&
			   preg_match('/^[a-zA-Z0-9]+$/', $_POST["nuevoApoderado"]) &&
			   preg_match('/^[a-zA-Z0-9]+$/', $_POST["nuevoPassword"])){

			   	/*=============================================
				VALIDAR IMAGEN
				=============================================*/

				$ruta = "";

				if(isset($_FILES["nuevaFoto"]["tmp_name"])){

					/*=============================================
					CREAMOS EL DIRECTORIO DONDE VAMOS A GUARDAR LA FOTO DEL USUARIO
					=============================================*/

					$directorio = "vistas/img/apoderados/".$_POST["nuevoApoderado"];
					mkdir($directorio, 0755);

					/*=============================================
					DE ACUERDO AL TIPO DE IMAGEN APLICAMOS LAS FUNCIONES POR DEFECTO DE PHP
					=============================================*/

					if($_FILES["nuevaFoto"]["type"] == "image/jpeg"){

						/*=============================================
						GUARDAMOS LA IMAGEN EN EL DIRECTORIO
						=============================================*/

						$aleatorio = mt_rand(100,999);

						$ruta = "vistas/img/apoderados/".$_POST["nuevoApoderado"]."/".$aleatorio.".jpg";

					
						move_uploaded_file($_FILES["nuevaFoto"]["tmp_name"], $ruta);

					}

					if($_FILES["nuevaFoto"]["type"] == "image/png"){

						/*=============================================
						GUARDAMOS LA IMAGEN EN EL DIRECTORIO
						=============================================*/

						$aleatorio = mt_rand(100,999);

						$ruta = "vistas/img/apoderados/".$_POST["nuevoApoderado"]."/".$aleatorio.".png";

					
						move_uploaded_file($_FILES["nuevaFoto"]["tmp_name"], $ruta);

					}

				}

				$tabla = "usuarios";
				//Nuevos
				//EditarRut,editarCelular,editarApem, editarApep

			//$encriptar = crypt($_POST["nuevoPassword"], '$2a$07$asxx54ahjppf45sd87a5a4dDDGsystemdev$');
				$encriptar = password_hash($_POST["nuevoPassword"], PASSWORD_DEFAULT, array("cost"=>10));
				$datos = array("nombre" => $_POST["nuevoNombre"],
					           "apep" => $_POST["nuevoApep"],
					           "apem" => $_POST["nuevoApem"],
					           "genero" => $_POST["nuevoGenero"],
					           "celular" => $_POST["nuevoCelular"],
					           "estadocivil" => $_POST["nuevoEcivil"],
					           "direccion" => $_POST["nuevoDireccion"],
					           "email" => $_POST["nuevoEmail"],
					           "fecha_nacimiento" => $_POST["nuevaFechaNacimiento"],
							   
					           "rut" => $_POST["nuevoRut"],
					           "usuario" => $_POST["nuevoApoderado"],
					           "password" => $encriptar,
					           "perfil" => $_POST["nuevoPerfil"],
					           "foto"=>$ruta);
				$respuesta = ModeloApoderados::mdlIngresarApoderado($tabla, $datos);
			
				if($respuesta == "ok"){

					echo '<script>

					swal({

						type: "success",
						title: "¡El apoderado ha sido guardado correctamente!",
						showConfirmButton: true,
						confirmButtonText: "Cerrar"

					}).then(function(result){

						if(result.value){
						
							window.location = "apoderados";

						}

					});
				

					</script>';


				}	


			}else{

				echo '<script>

					swal({

						type: "error",
						title: "¡El apoderado no puede ir vacío o llevar caracteres especiales!",
						showConfirmButton: true,
						confirmButtonText: "Cerrar"

					}).then(function(result){

						if(result.value){
						
							window.location = "apoderados";

						}

					});
				

				</script>';

			}


		}


	}

	/*=============================================
	MOSTRAR USUARIO
	=============================================*/

	public static function ctrMostrarApoderados($item, $valor){

		$tabla = "usuarios";

		$respuesta = ModeloApoderados::MdlMostrarApoderados($tabla, $item, $valor);

		return $respuesta;
	}

	/*=============================================
	EDITAR USUARIO
	=============================================*/

	public static function ctrEditarApoderado(){

		if(isset($_POST["editarApoderado"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["editarNombre"])){

				/*=============================================
				VALIDAR IMAGEN
				=============================================*/

				$ruta = $_POST["fotoActual"];

				if(isset($_FILES["editarFoto"]["tmp_name"]) && !empty($_FILES["editarFoto"]["tmp_name"])){

					/*list($ancho, $alto) = getimagesize($_FILES["editarFoto"]["tmp_name"]);

					$nuevoAncho = 500;
					$nuevoAlto = 500;*/

					/*=============================================
					CREAMOS EL DIRECTORIO DONDE VAMOS A GUARDAR LA FOTO DEL USUARIO
					=============================================*/

					$directorio = "vistas/img/apoderados/".$_POST["editarApoderado"];

					/*=============================================
					PRIMERO PREGUNTAMOS SI EXISTE OTRA IMAGEN EN LA BD
					=============================================*/

					if(!empty($_POST["fotoActual"])){

						unlink($_POST["fotoActual"]);

					}else{

						mkdir($directorio, 0755);

					}	

					/*=============================================
					DE ACUERDO AL TIPO DE IMAGEN APLICAMOS LAS FUNCIONES POR DEFECTO DE PHP
					=============================================*/

					if($_FILES["editarFoto"]["type"] == "image/jpeg"){

						/*=============================================
						GUARDAMOS LA IMAGEN EN EL DIRECTORIO
						=============================================*/

						$aleatorio = mt_rand(100,999);

						$ruta = "vistas/img/apoderados/".$_POST["editarApoderado"]."/".$aleatorio.".jpg";

					
						move_uploaded_file($_FILES["editarFoto"]["tmp_name"], $ruta);

					}

					if($_FILES["editarFoto"]["type"] == "image/png"){

						/*=============================================
						GUARDAMOS LA IMAGEN EN EL DIRECTORIO
						=============================================*/

						$aleatorio = mt_rand(100,999);

						$ruta = "vistas/img/apoderados/".$_POST["editarApoderado"]."/".$aleatorio.".png";

						
						move_uploaded_file($_FILES["editarFoto"]["tmp_name"], $ruta);

					}

				}

				$tabla = "usuarios";

				if($_POST["editarPassword"] != ""){

					if(preg_match('/^[a-zA-Z0-9]+$/', $_POST["editarPassword"])){

						//$encriptar = crypt($_POST["editarPassword"], '$2a$07$asxx54ahjppf45sd87a5a4dDDGsystemdev$');
						$encriptar = password_hash($_POST["editarPassword"], PASSWORD_DEFAULT, array("cost"=>10));

					}else{

						echo'<script>

								swal({
									  type: "error",
									  title: "¡La contraseña no puede ir vacía o llevar caracteres especiales!",
									  showConfirmButton: true,
									  confirmButtonText: "Cerrar"
									  }).then(function(result) {
										if (result.value) {

										window.location = "apoderados";

										}
									})

						  	</script>';

						  	return;

					}

				}else{

					$encriptar = $_POST["passwordActual"];

				}
				//EditarRut,editarCelular,editarApem, editarApep
				$datos = array("nombre" => $_POST["editarNombre"],
							   "apep" => $_POST["editarApep"],
							   "apem" => $_POST["editarApem"],
							   "genero" => $_POST["editarGenero"],
							   "celular" => $_POST["editarCelular"],
							   "estadocivil" => $_POST["editarEcivil"],
					           "direccion" => $_POST["editarDireccion"],
					           "email" => $_POST["editarEmail"],
					           "fecha_nacimiento" => $_POST["editarFechaNacimiento"],
							   
							   "rut" => $_POST["editarRut"],
							   "usuario" => $_POST["editarApoderado"],
							   "password" => $encriptar,
							   "perfil" => $_POST["editarPerfil"],
							   "foto" => $ruta);

				$respuesta = ModeloApoderados::mdlEditarApoderado($tabla, $datos);

				if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "El apoderado ha sido editado correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result) {
									if (result.value) {

									window.location = "apoderados";

									}
								})

					</script>';

				}


			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El nombre no puede ir vacío o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result) {
							if (result.value) {

							window.location = "apoderados";

							}
						})

			  	</script>';

			}

		}

	}

	/*=============================================
	BORRAR USUARIO
	=============================================*/

 public static function ctrBorrarApoderado(){

		if(isset($_GET["idApoderado"])){

			$tabla ="usuarios";
			$datos = $_GET["idApoderado"];

			if($_GET["fotoApoderado"] != ""){

				unlink($_GET["fotoApoderado"]);
				rmdir('vistas/img/apoderados/'.$_GET["apoderado"]);

			}

			$respuesta = ModeloApoderados::mdlBorrarApoderado($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

				swal({
					  type: "success",
					  title: "El apoderado ha sido borrado correctamente",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar",
					  closeOnConfirm: false
					  }).then(function(result) {
								if (result.value) {

								window.location = "apoderados";

								}
							})

				</script>';

			}		

		}

	}


}